//-----------------------------------------------------------------------------
// Plugin Name    : ChangeEnemyToActorImage
// Description    : Changes the enemy image to the actor's character chip
// Author         : [Your Name Here]
// Version        : 1.0.0
//-----------------------------------------------------------------------------

/*:
 * @plugindesc Changes the enemy image to the actor's character chip
 * @author [Your Name Here]
 * @version 1.0.0
 *
 * @help This plugin does not provide plugin commands.
 *
 * This plugin replaces the enemy image in battles with the actor's character
 * chip image. To use, simply tag the actors with a note containing the name of
 * the enemy image file to replace, in the following format:
 *
 * <replace_enemy: [enemyImageName]>
 *
 * Example:
 * <replace_enemy: Slime>
 *
 * This will replace any enemy with the "Slime" image with the character chip
 * image of the actor with the tag.
 */

(function() {
  'use strict';

  var _Sprite_Enemy_setBattler = Sprite_Enemy.prototype.setBattler;
  Sprite_Enemy.prototype.setBattler = function(battler) {
    _Sprite_Enemy_setBattler.call(this, battler);
    if (battler && battler.isActor()) {
      var actorId = battler.actorId();
      var replaceEnemyName = $dataActors[actorId].meta.replace_enemy;
      if (replaceEnemyName) {
        var bitmap = ImageManager.loadCharacter($dataActors[actorId].characterName());
        var big = ImageManager.isBigCharacter($dataActors[actorId].characterName());
        var index = $dataActors[actorId].characterIndex();
        this._mainSprite.bitmap = bitmap;
        this._mainSprite.setFrame(0, 0, 0, 0);
        this._mainSprite.setCharacterIndex(index);
        this._mainSprite.setIsBigCharacter(big);
        this._mainSprite.anchor.x = 0.5;
        this._mainSprite.anchor.y = 1;
        this._mainSprite.x = this._enemy.hpGauge_x();
        this._mainSprite.y = this._enemy.hpGauge_y();
        this._enemy.setBattlerName(replaceEnemyName);
      }
    }
  };
})();